﻿
namespace Framework.Data
{
    /// <summary>
    /// アプリ定数のデータソースリスナの引数です。
    /// </summary>
    public class AppSettingRequestArgs
    {
        /// <summary>
        /// アプリ定数のデータソースです。呼び出されたときにをセットします。
        /// </summary>
        public AppSettingDataSet DataSrc;

        /// <summary>
        /// キャッシュの依存関係です。呼び出されたときにをセットします。
        /// </summary>
        public System.Web.Caching.CacheDependency CacheDependency;
    }

    /// <summary>
    /// アプリ定数のデータソースリスナのインターフェースです。
    /// </summary>
    public interface IAppSettingRequestListener
    {
        /// <summary>
        /// データソースをリクエストします。呼び出された側ではargにデータソースなどの値をセットします。
        /// </summary>
        /// <param name="arg"></param>
        void RequestDataSrc(AppSettingRequestArgs arg);
    }
}
